<%@ page language="java" buffer="none" contentType="text/html; charset=utf-8"%>
<%@ page import="com.genesyslab.ail.AilLoader" %>
<%@ page import="com.genesyslab.ail.AilFactory" %>
<%@ page import="com.genesyslab.ail.Contact" %>
<%@ page import="com.genesyslab.ail.ContactManager" %>
<%@ page import="com.genesyslab.ail.ContactAttributeMetaData" %>
<%@ page import="com.genesyslab.ail.ContactAttributeValue" %>
<%@ page import="com.genesyslab.ail.exception.RequestFailedException" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collection" %>
<%@ page import="java.util.Iterator" %>
<%@ page import="java.util.Vector" %>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <script language="javascript">
      window.parent.includeGDFunctionalities(window);

      function custom_load() {
        activateGDFunctionalities();
      }

      function custom_unload() {
        unactivateGDFunctionalities();
      }
    </script>
  </head>
  <body height="0" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="custom_load()" onunload="custom_unload()">
    <script language="javascript">
<%
    // Get datas from the request
    String idContact = (String)request.getParameter("idContact");
    String[] names = (String[]) request.getParameterValues("dataName");
    String[] values = (String[]) request.getParameterValues("dataValue");
    String[] changed = (String[]) request.getParameterValues("dataChanged");
    ArrayList idFromNames = new ArrayList(); // Array associating attritbute names with idx in the tabs names, values and changed
    for(int i=0; i<names.length; i++) {
        idFromNames.add(i, names[i]);
    }

    // Initialize AIL related data
    AilFactory factory = AilLoader.getAilFactory();
    ContactManager contactManager = factory.getContactManager();
    Contact contact = factory.getContactManager().getContact(idContact, null);

    // Update Attribute Values of the contact
    // Get all the attributes of a contact
    Collection metaDatasCol = contactManager.getAllContactAttributeMetaData();
    if ( (metaDatasCol != null) && (!metaDatasCol.isEmpty()) ) {
        Iterator                    metaDatasIt = metaDatasCol.iterator();
        ContactAttributeMetaData    metaData = null;
        Collection                  metaDataValuesCol = null;
        ContactAttributeValue       metaDataValue = null;
        String                      metaDataName = null;
        int     idxData = 0;
        boolean saveContact = false;
        while (metaDatasIt.hasNext()) {
            metaData = (ContactAttributeMetaData) metaDatasIt.next();
            if (metaData != null) {
                // For each attribute defined
                metaDataName = metaData.getName();
                // Get from its name its corresponding idx in the tabs
                idxData = idFromNames.indexOf(metaDataName);
                if ( (idxData >= 0) && (idxData < changed.length) && ("true".equalsIgnoreCase(changed[idxData])) ) {
                    // The primary value of the attribut has changed
                    try {
                        // Get the primary attribute value for the contact
                        metaDataValuesCol = contact.getAttributeValues(metaData, true);
                        if ( (metaDataValuesCol == null) || metaDataValuesCol.isEmpty() ) {
                            // No value defined yet -> create one from the new attribute value
                            metaDataValuesCol = new Vector();
                            metaDataValue = metaData.createValue(values[idxData]);
                            metaDataValuesCol.add(metaDataValue);
                        } else {
                            // Value already defined -> replace it with the new attribute value
                            metaDataValue = (ContactAttributeValue)metaDataValuesCol.iterator().next();
                            metaDataValue.setStrValue(values[idxData]);
                            metaDataValuesCol.clear();
                            metaDataValuesCol.add(metaDataValue);
                        }
                        metaDataValue.setDescription("");
                        metaDataValue.setPrimary(true);
                        contact.setAttributeValues(metaData, metaDataValuesCol);
                        saveContact = true;
                    } catch(RequestFailedException requestFailedException) {
                        System.out.println("Contact AttributeValues update failed: " + requestFailedException);
%>
      showWarningMessage("Contact AttributeValues update failed!");
<%
                    }
                }
            }
        }
        if (saveContact) {
            // The contact has been changed, then save it
            try {
                contact.save();
%>
      showInformationMessage("Contact sucessfully saved!");
<%
            } catch( RequestFailedException requestFailedException ) {
                System.out.println("Contact AttributeValues update failed (on save contact) : " + requestFailedException);
%>
      showWarningMessage("Contact AttributeValues update failed (on save contact)!");
<%
            }
        }
    }
%>
    </script>
  </body>
</html>
